#ifndef _TRAYHANDLER_CPP
#define _TRAYHANDLER_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "Entry.H"
#include "Init.H"
#include "TrayIcon.H"
#include "TrayHandler.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool bFirstCall = true;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK TrayIconProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    while(true)
    {
        if(uMsg == WM_COMMAND)
        {
            if(LOWORD(wParam) == ID_EXIT)
            {
                DestroyWindow(hWnd);
            }
			else if(LOWORD(wParam) == ID_STARTSERVER)
            {
				StartService();
            }
			else if(LOWORD(wParam) == ID_STOPSERVER)
            {
				StopService();
            }
			else if(LOWORD(wParam) == ID_CANCEL)
            {
            }

            break;
        }

        if(uMsg == WM_CREATE)
        {
            TB_CREATED = RegisterWindowMessage("TaskbarCreated");
            break;
        }

        if(uMsg == WM_SHELLNOTIFY)
        {
            if(lParam == WM_RBUTTONDOWN)
            {
				POINT MyPT;
	
				GetCursorPos(&MyPT);
                SetForegroundWindow(hWnd);
                TrackPopupMenuEx(hFileMenu, TPM_LEFTALIGN| TPM_RIGHTBUTTON, MyPT.x, MyPT.y, hWnd, NULL);
                PostMessage(hWnd, WM_NULL, 0, 0);
            }

            break;
        }

        if(uMsg == WM_DESTROY)
        {
            UnregisterClass(gsTitleCaption, ghAppInstance);
            Shell_NotifyIconA(NIM_DELETE, &MyTrayNotifiy);
            PostQuitMessage(0);
            break;
        }

        if(uMsg == WM_CLOSE)
        {
            DestroyWindow(hWnd);
            break;
        }

        if(uMsg == TB_CREATED)
        {
            Shell_NotifyIcon(NIM_ADD, &MyTrayNotifiy);
        }

        break;
    }

    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
